/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <sys/types.h>
#include <sys/errno.h>
#include <sys/param.h>
#include <sys/stropts.h>
#include <sys/stream.h>
#include <sys/kmem.h>
#include <sys/conf.h>
#include <sys/devops.h>
#include <sys/ksynch.h>
#include <sys/stat.h>
#include <sys/modctl.h>
#include <sys/debug.h>
#include <sys/dlpi.h>
#include <sys/ethernet.h>
#include <sys/gld.h>
#include <sys/pci.h>
#include <sys/ddi.h>
#include <sys/sunddi.h>


struct mx_jpool_entry;

struct mx_jpool_entry{
	SLIST_ENTRY(mx_jpool_entry) entries;
	ddi_dma_handle_t dma_handle;
	ddi_acc_handle_t acc_handle;				  
	caddr_t buf;
	struct mx_ether *eth;		  
	mcp_dma_addr_t dma;	/* Kept in network byte order*/
	frtn_t free_func;
};

SLIST_HEAD(jpool_head, mx_jpool_entry);

struct mx_jpool_stuff {
	struct jpool_head head;
	kmutex_t mtx;
	int num_alloc;
	int low_water;
};

struct mx_ether_buffer_info {
        mblk_t *m;
	caddr_t ptr;
	struct mx_jpool_entry *j;
};

struct mx_ether_stat {
	struct kstat_named rx_jumbo_cnt;
	struct kstat_named rx_copy;
	struct kstat_named xmit_zero_len;
	struct kstat_named xmit_pullup;
	struct kstat_named xmit_pullup_first;
	struct kstat_named xmit_lowbuf;
	struct kstat_named xmit_stall;
	struct kstat_named xmit_sched;
};

#define MX_ETHER_STAT_INC(eth, field) (((struct mx_ether_stat *)eth->arch.ksp->ks_data)->field.value.ul)++

struct mx_ether_arch {
	gld_mac_info_t *macinfo;
	mx_instance_state_t *is;
	struct mx_jpool_stuff jpool;
	kmutex_t txlock;
	kmutex_t intrlock;
	ddi_dma_handle_t tx_handles[NUM_TX];
	int stall;
	int sched;
	int j_rx_cnt;
	kstat_t *ksp;
	struct jpool_head small_jpool_head;
};

#define MX_SMALL_THRESH 128


/*
  This file uses MX driver indentation.

  Local Variables:
  c-file-style:"linux"
  tab-width:8
  End:
*/
